<?php
/* --------------------------------------------------------------
   CurrentUserConfigurationService.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration;

use Gambio\Admin\UserConfiguration\Exceptions\UserConfigurationNotFoundException;
use Gambio\Admin\UserConfiguration\Interfaces\CurrentUserConfigurationService as CurrentUserConfigurationServiceInterface;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfiguration;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationKey;
use Gambio\Admin\UserConfiguration\Interfaces\UserConfigurationRepository;
use Gambio\Admin\UserConfiguration\Interfaces\UserId;

/**
 * Class CurrentUserConfigurationService
 *
 * @package Gambio\Admin\UserConfiguration
 */
class CurrentUserConfigurationService implements CurrentUserConfigurationServiceInterface
{
    /**
     * @var UserId
     */
    private $userId;
    
    /**
     * @var UserConfigurationRepository
     */
    private $repository;
    
    
    /**
     * UserConfigurationService constructor.
     *
     * @param UserId                      $userId
     * @param UserConfigurationRepository $repository
     */
    public function __construct(UserId $userId, UserConfigurationRepository $repository)
    {
        $this->userId     = $userId;
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getValue(string $key, string $default = null): ?string
    {
        try {
            return $this->repository->getByKey($this->userId, Model\UserConfigurationKey::create($key))->value();
        } catch (UserConfigurationNotFoundException $e) {
            return $default;
        }
    }
    
    
    /**
     * @inheritDoc
     */
    public function storeConfiguration(UserConfiguration $configuration): void
    {
        $this->repository->store($this->userId, $configuration);
    }
}